package ru.yandex.qe.bus.features.log;

import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.phase.Phase;

/**
 * Established by terry
 * on 14.02.16.
 */
public class SetupEndingOutLogInterceptor extends AbstractPhaseInterceptor<Message> {
    private final LogFeature logFeature;

    public SetupEndingOutLogInterceptor(LogFeature logFeature) {
        super(Phase.SETUP_ENDING);
        this.logFeature = logFeature;
    }

    @Override
    public void handleMessage(Message message) throws Fault {
        if (!isRequestor(message)) {
            logFeature.removeReqIdFromMDC();
        }
    }

    @Override
    public void handleFault(Message message) {
        try {
            super.handleFault(message);
        } finally {
            logFeature.removeReqIdFromMDC();
        }
    }
}
