package ru.yandex.qe.bus.features.version;

import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.phase.Phase;

/**
 * User: terry
 * Date: 05.10.13
 * Time: 22:34
 */
public class OutVersionInterceptor extends AbstractPhaseInterceptor<Message> {

    private final VersionFeature versionFeature;

    public OutVersionInterceptor(VersionFeature versionFeature) {
        super(Phase.POST_LOGICAL);
        this.versionFeature = versionFeature;
    }

    @Override
    public void handleMessage(Message message) throws Fault {
        versionFeature.putVersionsInHeaders(message);
    }
}
