package ru.yandex.qe.bus.features.version;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.joda.time.DateTime;

import static org.apache.commons.lang3.builder.ToStringBuilder.reflectionToString;
import static org.apache.commons.lang3.builder.ToStringStyle.SHORT_PREFIX_STYLE;

/**
 * User: terry
 * Date: 14.10.13
 * Time: 20:43
 */
@Immutable
public class Version {
    private final String serverGroup;
    private final String serverArtifact;
    private final String serverVersion;
    private final String apiGroup;
    private final String apiArtifact;
    private final String apiVersion;
    private final String busVersion;
    private final String hostname;
    private final DateTime startTime;

    public Version(
            @JsonProperty("serverGroup") @Nonnull String serverGroup,
            @JsonProperty("serverArtifact") @Nonnull String serverArtifact,
            @JsonProperty("serverVersion") @Nonnull String serverVersion,
            @JsonProperty("apiGroup") @Nullable String apiGroup,
            @JsonProperty("apiArtifact") @Nullable String apiArtifact,
            @JsonProperty("apiVersion") @Nullable String apiVersion,
            @JsonProperty("busVersion") @Nonnull String busVersion,
            @JsonProperty("hostname") @Nonnull String hostname,
            @JsonProperty("startTime") @Nonnull DateTime startTime) {
        this.serverGroup = serverGroup;
        this.serverArtifact = serverArtifact;
        this.serverVersion = serverVersion;
        this.apiGroup = apiGroup;
        this.apiArtifact = apiArtifact;
        this.apiVersion = apiVersion;
        this.busVersion = busVersion;
        this.hostname = hostname;
        this.startTime = startTime;
    }

    @Nonnull
    public String getServerVersion() {
        return serverVersion;
    }

    @Nullable
    public String getApiVersion() {
        return apiVersion;
    }

    @Nonnull
    public String getBusVersion() {
        return busVersion;
    }

    public String getHostname() {
        return hostname;
    }

    @Nonnull
    public DateTime getStartTime() {
        return startTime;
    }

    @Override
    public String toString() {
        return reflectionToString(this, SHORT_PREFIX_STYLE);
    }

    public String getServerGroup() {
        return serverGroup;
    }

    public String getServerArtifact() {
        return serverArtifact;
    }

    public String getApiGroup() {
        return apiGroup;
    }

    public String getApiArtifact() {
        return apiArtifact;
    }
}
