package ru.yandex.qe.bus.joda;

import javax.ws.rs.ext.ParamConverter;

import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.DateTimeParser;
import org.joda.time.format.ISODateTimeFormat;

public class DateTimeParamConverter implements ParamConverter<DateTime> {

    private static final DateTimeFormatter FORMATTER =
            new DateTimeFormatterBuilder().append(null, new DateTimeParser[]{
                    ISODateTimeFormat.basicDate().getParser(),
                    ISODateTimeFormat.dateOptionalTimeParser().getParser()}).toFormatter();

    @Override
    public DateTime fromString(String string) throws IllegalArgumentException {
        return FORMATTER.parseDateTime(string);
    }

    @Override
    public String toString(DateTime dateTime) throws IllegalArgumentException {
        return dateTime.toString();
    }
}
