package ru.yandex.qe.bus.joda;

import javax.ws.rs.ext.ParamConverter;

import org.joda.time.Duration;
import org.joda.time.Period;

/**
 * @author Alexei Zakharov (ayza)
 */
public class DurationParamConverter implements ParamConverter<Duration> {
  @Override
  public Duration fromString(String value) {
    return Period.parse(value).toStandardDuration();
  }

  @Override
  public String toString(Duration value) {
    return value.toPeriod().toString();
  }
}
