package ru.yandex.qe.bus.joda;

import javax.ws.rs.ext.ParamConverter;

import org.joda.time.Instant;

/**
 * @author Alexei Zakharov (ayza)
 */
public class InstantParamConverter implements ParamConverter<Instant> {
  @Override
  public Instant fromString(String value) {
    try {
      long longValue = Long.parseLong(value);
      return new Instant(longValue * 1000);
    } catch (NumberFormatException e) {
      return Instant.parse(value);
    }
  }

  @Override
  public String toString(Instant value) {
    return value.toString();
  }
}

