package ru.yandex.qe.bus.servlet;

import org.apache.cxf.Bus;
import org.apache.cxf.transport.servlet.CXFNonSpringServlet;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.XmlWebApplicationContext;

import ru.yandex.qe.bus.factories.BusServerBuilderBean;

public class BusServlet extends CXFNonSpringServlet {

    public BusServlet(ApplicationContext ctx) {
        setBus(ctx);
    }

    private void setBus(ApplicationContext ctx) {
        try {
            setBus(ctx.getBean(BusServerBuilderBean.class).getBus());
        } catch (NoSuchBeanDefinitionException ex) {
            setBus(ctx.getBean(Bus.class));
        }
    }

    public BusServlet(XmlWebApplicationContext ctx) {
        ctx.refresh();
        setBus(ctx);
    }
}
