package ru.yandex.qe.cache;

import javax.annotation.Nullable;

import net.sf.ehcache.config.CacheConfiguration;
import org.springframework.beans.factory.FactoryBean;

import static net.sf.ehcache.config.CacheConfiguration.CacheEventListenerFactoryConfiguration;

/**
 * User: terry
 * Date: 26.09.13
 * Time: 15:03
 */
public class CacheConfigurationFactoryBean implements FactoryBean<CacheConfiguration> {

    private CacheConfiguration cacheConfiguration;

    @Nullable
    private CacheEventListenerFactoryConfiguration cacheEventListenerFactory;

    public void setCacheConfiguration(CacheConfiguration cacheConfiguration) {
        this.cacheConfiguration = cacheConfiguration;
    }

    public void setCacheEventListenerFactory(@Nullable CacheEventListenerFactoryConfiguration cacheEventListenerFactory) {
        this.cacheEventListenerFactory = cacheEventListenerFactory;
    }

    @Override
    public CacheConfiguration getObject() throws Exception {
        if (cacheEventListenerFactory != null) {
            cacheConfiguration.addCacheEventListenerFactory(cacheEventListenerFactory);
        }
        return cacheConfiguration;
    }

    @Override
    public Class<?> getObjectType() {
        return CacheConfiguration.class;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }
}
