package ru.yandex.qe.cache;

import org.springframework.beans.factory.FactoryBean;

import static net.sf.ehcache.config.CacheConfiguration.CacheEventListenerFactoryConfiguration;

/**
 * User: terry
 * Date: 26.09.13
 * Time: 16:38
 */
public class CacheEventListenerFactoryFactoryBean implements FactoryBean<CacheEventListenerFactoryConfiguration> {

    private String fullyQualifiedClassPath;
    private String properties;

    public void setClassName(String fullyQualifiedClassPath) {
        this.fullyQualifiedClassPath = fullyQualifiedClassPath;
    }

    public void setProperties(String properties) {
        this.properties = properties;
    }

    @Override
    public CacheEventListenerFactoryConfiguration getObject() throws Exception {
        final CacheEventListenerFactoryConfiguration cacheEventListenerFactoryConfiguration = new CacheEventListenerFactoryConfiguration();
        cacheEventListenerFactoryConfiguration.setClass(fullyQualifiedClassPath);
        cacheEventListenerFactoryConfiguration.setProperties(properties);
        return cacheEventListenerFactoryConfiguration;
    }

    @Override
    public Class<?> getObjectType() {
        return CacheEventListenerFactoryConfiguration.class;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }
}
