package ru.yandex.qe.cache;

import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.FactoryConfiguration;
import org.springframework.beans.factory.FactoryBean;

/**
 * User: terry
 * Date: 26.09.13
 * Time: 14:57
 */
public class CacheManagerConfigurationFactoryBean implements FactoryBean<Configuration> {

    private FactoryConfiguration cacheManagerPeerListenerFactory;
    private FactoryConfiguration cacheManagerPeerProviderFactory;

    private String name;

    public void setCacheManagerPeerListenerFactory(FactoryConfiguration cacheManagerPeerListenerFactory) {
        this.cacheManagerPeerListenerFactory = cacheManagerPeerListenerFactory;
    }

    public void setCacheManagerPeerProviderFactory(FactoryConfiguration cacheManagerPeerProviderFactory) {
        this.cacheManagerPeerProviderFactory = cacheManagerPeerProviderFactory;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Configuration getObject() throws Exception {
        final Configuration config = new Configuration();
        if (cacheManagerPeerProviderFactory != null) {
            config.addCacheManagerPeerProviderFactory(cacheManagerPeerProviderFactory);
        }
        if (cacheManagerPeerListenerFactory != null) {
            config.addCacheManagerPeerListenerFactory(cacheManagerPeerListenerFactory);
        }
        if (name != null) {
            config.setName(name);
        }
        return config;
    }


    @Override
    public Class<?> getObjectType() {
        return Configuration.class;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }
}
