package ru.yandex.qe.cache;

import java.util.Set;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;

import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.config.Configuration;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.SmartFactoryBean;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * User: terry
 * Date: 26.09.13
 * Time: 13:18
 */
public class EhCacheManagerFactoryBean implements SmartFactoryBean<CacheManager>, DisposableBean {

    @Autowired(required = false)
    private Set<Ehcache> caches;

    @Autowired(required = false)
    private Configuration configuration;

    private CacheManager cacheManager;

    @PostConstruct
    private void init() {
        cacheManager = configuration != null ? new CacheManager(configuration) : CacheManager.newInstance();
        if (caches != null) {
            for (Ehcache cache : caches) {
                cacheManager.addCache(cache);
            }
        }
    }

    @Override
    public CacheManager getObject() throws Exception {
        return cacheManager;
    }

    @Override
    public Class<?> getObjectType() {
        return CacheManager.class;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    @Override
    @PreDestroy
    public void destroy() throws Exception {
        if (cacheManager != null) {
            cacheManager.shutdown();
            configuration = null;
        }
    }

    @Override
    public boolean isPrototype() {
        return false;
    }

    @Override
    public boolean isEagerInit() {
        return true;
    }
}
