package ru.yandex.qe.cache;

import net.sf.ehcache.config.FactoryConfiguration;
import org.springframework.beans.factory.FactoryBean;

/**
 * User: terry
 * Date: 26.09.13
 * Time: 16:28
 */
public class FactoryConfigurationFactoryBean implements FactoryBean<FactoryConfiguration> {

    private String fullyQualifiedClassPath;
    private String properties;

    public void setClassName(String fullyQualifiedClassPath) {
        this.fullyQualifiedClassPath = fullyQualifiedClassPath;
    }

    public void setProperties(String properties) {
        this.properties = properties;
    }

    @Override
    public FactoryConfiguration getObject() throws Exception {
        final FactoryConfiguration factoryConfiguration = new FactoryConfiguration();
        factoryConfiguration.setClass(fullyQualifiedClassPath);
        factoryConfiguration.setProperties(properties);
        return factoryConfiguration;
    }

    @Override
    public Class<?> getObjectType() {
        return FactoryConfiguration.class;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }
}
