package ru.yandex.qe.cache;

import java.util.Collections;
import java.util.Set;

import net.sf.ehcache.config.FactoryConfiguration;
import org.springframework.beans.factory.FactoryBean;

/**
 * User: terry
 * Date: 26.09.13
 * Time: 18:41
 */
public class ManualRMIPeerProviderFactoryBean implements FactoryBean<FactoryConfiguration> {

    private String peersHosts;
    private String port;

    private Set<String> cachesNames;

    public void setPeersHosts(String peersHosts) {
        this.peersHosts = peersHosts;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setCachesNames(Set<String> cachesNames) {
        this.cachesNames = cachesNames;
    }

    public void setCacheName(String cacheName) {
        this.cachesNames = Collections.singleton(cacheName);
    }

    @Override
    public FactoryConfiguration getObject() throws Exception {
        final FactoryConfiguration factoryConfiguration = new FactoryConfiguration();
        factoryConfiguration.setClass("net.sf.ehcache.distribution.RMICacheManagerPeerProviderFactory");
        StringBuilder builder = new StringBuilder("peerDiscovery=manual, rmiUrls=");
        for (String host : peersHosts.trim().split(",")) {
            for (String cacheName : cachesNames) {
                builder.append("//").append(host.trim()).append(":").append(port).append("/").append(cacheName).append("|");

            }
        }
        builder.deleteCharAt(builder.length() - 1);
        factoryConfiguration.setProperties(builder.toString());
        return factoryConfiguration;
    }

    @Override
    public Class<?> getObjectType() {
        return FactoryConfiguration.class;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }
}
