package ru.yandex.qe.cache;

import java.util.Arrays;
import java.util.Collections;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;

import net.sf.ehcache.CacheManager;
import net.sf.ehcache.distribution.CacheManagerPeerProvider;
import net.sf.ehcache.distribution.CacheManagerPeerProviderFactory;
import net.sf.ehcache.util.PropertyUtil;

/**
 * @author lvovich
 */
public class QloudRMICacheManagerPeerProviderFactory extends CacheManagerPeerProviderFactory {

    @Override
    public CacheManagerPeerProvider createCachePeerProvider(final CacheManager cacheManager, final Properties properties) {
        return createQloudCacheManagerPeerProvicer(cacheManager, properties);
    }

    private CacheManagerPeerProvider createQloudCacheManagerPeerProvicer(CacheManager cacheManager, Properties properties) {
        String caches = PropertyUtil.extractAndLogProperty("caches", properties);
        Set<String> cacheNames;
        if (caches == null || caches.isEmpty()) {
            cacheNames = Collections.emptySet();
        } else {
            cacheNames = Arrays.stream(caches.split("\\|")).map(String::trim).collect(Collectors.toSet());
        }
        String myHostName = PropertyUtil.extractAndLogProperty("myHostName", properties);
        int port = Integer.parseInt(PropertyUtil.extractAndLogProperty("port", properties));
        return new QloudCacheManagerPeerProvider(cacheManager, cacheNames, myHostName, port);
    }
}
