package ru.yandex.qe.cache;

import java.util.Set;

import net.sf.ehcache.config.FactoryConfiguration;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Value;

/**
 * User: terry
 * Date: 26.09.13
 * Time: 18:41
 */
public class QloudRMIPeerProviderFactoryBean implements FactoryBean<FactoryConfiguration> {

    @Value("${qe.hostname}")
    private String myHostName;

    private Set<String> cachesNames;

    private int port = 40001;

    public void setCachesNames(Set<String> cachesNames) {
        this.cachesNames = cachesNames;
    }

    public void setPort(final int port) {
        this.port = port;
    }

    @Override
    public FactoryConfiguration getObject() throws Exception {
        final FactoryConfiguration factoryConfiguration = new FactoryConfiguration();
        factoryConfiguration.setClass(QloudRMICacheManagerPeerProviderFactory.class.getName());
        StringBuilder builder = new StringBuilder("caches=");
        for (String cacheName : cachesNames) {
            builder.append(cacheName).append("|");

        }
        builder.deleteCharAt(builder.length() - 1);
        builder.append("\n");
        builder.append("myHostName=").append(myHostName).append("\n");
        builder.append("port=").append(port);
        factoryConfiguration.setProperties(builder.toString());
        return factoryConfiguration;
    }

    @Override
    public Class<?> getObjectType() {
        return FactoryConfiguration.class;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }
}
