package ru.yandex.qe.ssl;

import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Set;
import java.util.regex.Pattern;

/**
 * @author rurikk
 */
class CnPatternChecker extends PKIXCertPathChecker {
    private Pattern peerCnPattern;

    public CnPatternChecker(Pattern peerCnPattern) {
        this.peerCnPattern = peerCnPattern;
    }

    @Override
    public void init(boolean forward) throws CertPathValidatorException {
    }

    @Override
    public boolean isForwardCheckingSupported() {
        return true;
    }

    @Override
    public Set<String> getSupportedExtensions() {
        return null;
    }

    @Override
    public void check(Certificate cert, Collection<String> unresolvedCritExts) throws CertPathValidatorException {
        String cn = SslUtils.getCN(((X509Certificate) cert).getSubjectDN());
        if (!peerCnPattern.matcher(cn).matches()) {
            throw new CertPathValidatorException("CN pattern mismatch: expected = " + peerCnPattern + ", got = " + cn);
        }
    }
}
