package ru.yandex.qe.http.telemetry;

import org.apache.http.conn.HttpClientConnectionManager;

import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.qe.http.HttpConnectionManagerBuilder;

/**
 * Established by terry
 * on 07.02.16.
 */
public class InstrumentedHttpConnectionManagerBuilder extends HttpConnectionManagerBuilder {

    private final MetricRegistry metricRegistry;
    private final String label;

    public InstrumentedHttpConnectionManagerBuilder(MetricRegistry metricRegistry, String label) {
        this.metricRegistry = metricRegistry;
        this.label = label;
    }

    @Override
    public HttpClientConnectionManager build() {
        return new InstrumentedHttpConnectionManager(super.build(), metricRegistry, label);
    }
}
