package ru.yandex.qe.http.telemetry;

import java.io.IOException;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.protocol.HttpContext;

import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.monlib.metrics.primitives.Rate;
import ru.yandex.monlib.metrics.registry.MetricRegistry;

/**
 * Established by terry
 * on 07.02.16.
 */
public class InstrumentedHttpRequestInterceptor implements HttpRequestInterceptor {

    private final Rate requestRate;

    public InstrumentedHttpRequestInterceptor(MetricRegistry metricRegistry, String label) {
        this.requestRate = metricRegistry.rate("http_client.request_rate", Labels.of("http_client_label", label));
    }

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        requestRate.inc();
    }
}
