package ru.yandex.qe.http.telemetry;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.protocol.HttpContext;

import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.monlib.metrics.primitives.Rate;
import ru.yandex.monlib.metrics.registry.MetricRegistry;

/**
 * Established by terry
 * on 07.02.16.
 */
public class InstrumentedHttpResponseInterceptor implements HttpResponseInterceptor {

    private final String label;
    private final MetricRegistry metricRegistry;
    private final Rate totalResponseRate;
    private final ConcurrentMap<Integer, Rate> responseRatesByCode = new ConcurrentHashMap<>();

    public InstrumentedHttpResponseInterceptor(MetricRegistry metricRegistry, String label) {
        this.metricRegistry = metricRegistry;
        this.label = label;
        this.totalResponseRate = metricRegistry.rate("http_client.response_rate",
                Labels.of("http_client_label", label, "http_code", "all"));
    }

    @Override
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        totalResponseRate.inc();
        int statusCode = response.getStatusLine().getStatusCode();
        responseRatesByCode.computeIfAbsent(statusCode, c -> metricRegistry.rate("http_client.response_rate",
                Labels.of("http_client_label", label, "http_code", c.toString()))).inc();
    }
}
