package ru.yandex.qe.http.telemetry;

import org.apache.http.impl.client.CloseableHttpClient;
import org.springframework.beans.factory.FactoryBean;

import ru.yandex.monlib.metrics.registry.MetricRegistry;

/**
 * Established by terry
 * on 02.01.14.
 */
public class MetricsInstrumentedHttpClientFactoryBean extends MetricsInstrumentedHttpClientBuilder implements FactoryBean<CloseableHttpClient> {

    public MetricsInstrumentedHttpClientFactoryBean(String label, MetricRegistry metricRegistry) {
        super(label, metricRegistry);
    }

    @Override
    public CloseableHttpClient getObject() throws Exception {
        return build();
    }

    @Override
    public Class<?> getObjectType() {
        return CloseableHttpClient.class;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }
}

