package ru.yandex.qe.http.telemetry;

import java.util.concurrent.TimeUnit;

import com.google.common.base.Stopwatch;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.protocol.HttpContext;

import ru.yandex.monlib.metrics.histogram.Histograms;
import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.monlib.metrics.primitives.Histogram;
import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.qe.http.aspects.HttpAspect;

/**
 * Established by terry
 * on 02.01.14.
 */
public class MetricsTelemetryAspect implements HttpAspect {

    private final Histogram totalTime;

    private Stopwatch stopwatch;

    public MetricsTelemetryAspect(MetricRegistry metricRegistry, String label) {
        this.totalTime = metricRegistry.histogramRate("http_client.request_duration_millis",
                Labels.of("http_client_label", label), Histograms.exponential(22, 2.0d, 1.0d));
    }

    @Override
    public void beforeInvoke(HttpHost httpHost, HttpRequest httpRequest, HttpContext httpContext) {
        stopwatch = Stopwatch.createStarted();
    }

    @Override
    public void afterInvoke(HttpResponse httpResponse, HttpHost httpHost, HttpRequest httpRequest, HttpContext httpContext) {
        if (stopwatch != null) {
            totalTime.record(stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }
    }

    @Override
    public void onFail(Exception exception, HttpHost httpHost, HttpRequest httpRequest, HttpContext httpContext) {
        if (stopwatch != null) {
            totalTime.record(stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }
    }

}
