package ru.yandex.qe.http.telemetry;

import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.qe.http.aspects.HttpAspect;
import ru.yandex.qe.http.aspects.HttpAspectFactory;

/**
 * Established by terry
 * on 02.01.14.
 */
public class MetricsTelemetryAspectFactory implements HttpAspectFactory {

    private final MetricRegistry metricRegistry;
    private final String label;

    public MetricsTelemetryAspectFactory(MetricRegistry metricRegistry, String label) {
        this.metricRegistry = metricRegistry;
        this.label = label;
    }

    @Override
    public HttpAspect getAspect() {
        return new MetricsTelemetryAspect(metricRegistry, label);
    }
}
