package ru.yandex.qe.http;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;

import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;

import org.apache.http.HttpHost;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;

/**
 * @author lvovich
 */
public class QeSSLConnectionSockerFactory extends SSLConnectionSocketFactory {

    private final X509HostnameVerifier hostnameVerifier;

    public QeSSLConnectionSockerFactory(final SSLContext sslContext, final X509HostnameVerifier hostnameVerifier) {
        super(sslContext, hostnameVerifier);
        this.hostnameVerifier = hostnameVerifier;
    }

    @Override
    public Socket connectSocket(final int connectTimeout, final Socket socket, final HttpHost host, final InetSocketAddress remoteAddress, final InetSocketAddress localAddress, final HttpContext context) throws IOException {
        Args.notNull(host, "HTTP host");
        Args.notNull(remoteAddress, "Remote address");
        final Socket sock = socket != null ? socket : createSocket(context);
        if (localAddress != null) {
            sock.bind(localAddress);
        }
        try {
            sock.connect(remoteAddress, connectTimeout);
        } catch (final IOException ex) {
            try {
                sock.close();
            } catch (final IOException ignore) {
            }
            throw ex;
        }
        // Setup SSL layering if necessary
        if (sock instanceof SSLSocket) {
            final SSLSocket sslsock = (SSLSocket) sock;
            final SSLParameters sslParameters = sslsock.getSSLParameters();
            SNIHostName serverName = new SNIHostName(host.getHostName());
            List<SNIServerName> serverNames = new ArrayList<>(1);
            serverNames.add(serverName);
            sslParameters.setServerNames(serverNames);
            sslsock.setSSLParameters(sslParameters);
            sslsock.startHandshake();
            verifyHostname(sslsock, host.getHostName());
            return sock;
        } else {
            return createLayeredSocket(sock, host.getHostName(), remoteAddress.getPort(), context);
        }
    }

    private void verifyHostname(final SSLSocket sslsock, final String hostname) throws IOException {
        try {
            hostnameVerifier.verify(hostname, sslsock);
            // verifyHostName() didn't blowup - good!
        } catch (final IOException iox) {
            // close the socket before re-throwing the exception
            try { sslsock.close(); } catch (final Exception x) { /*ignore*/ }
            throw iox;
        }
    }

}
