package ru.yandex.qe.http.aspects;

import java.io.IOException;

import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;

/**
 * Created with IntelliJ IDEA.
 * User: terry
 * Date: 30.06.13
 * Time: 17:46
 */
public class AspectCapableHttpClient extends CloseableHttpClient {

    private final HttpAspectFactory httpAspectFactory;
    private final CloseableHttpClient delegate;

    public AspectCapableHttpClient(HttpAspectFactory httpAspectFactory, CloseableHttpClient delegate) {
        this.httpAspectFactory = httpAspectFactory;
        this.delegate = delegate;
    }

    @Override
    protected CloseableHttpResponse doExecute(HttpHost target, HttpRequest request, HttpContext context) throws IOException {
        final HttpAspect httpAspect = httpAspectFactory.getAspect();
        httpAspect.beforeInvoke(target, request, context);
        try {
            final CloseableHttpResponse httpResponse = delegate.execute(target, request, context);
            httpAspect.afterInvoke(httpResponse, target, request, context);
            return httpResponse;
        } catch (Exception ex) {
            httpAspect.onFail(ex, target, request, context);
            throw ex;
        }
    }

    @Override
    public void close() throws IOException {
        delegate.close();
    }

    @Override
    public HttpParams getParams() {
        return delegate.getParams();
    }

    @Override
    public ClientConnectionManager getConnectionManager() {
        return delegate.getConnectionManager();
    }
}
