package ru.yandex.qe.http.aspects.log;

import java.util.List;

import ru.yandex.qe.http.aspects.HttpAspect;
import ru.yandex.qe.http.aspects.HttpAspectFactory;
import ru.yandex.qe.logging.security.PrivateHeaderSecurityGuard;

/**
 * Created with IntelliJ IDEA.
 * User: terry
 * Date: 30.06.13
 * Time: 18:50
 */
public class LogHttpAspectFactory implements HttpAspectFactory {

    private final List<PrivateHeaderSecurityGuard> privateHeaderSecurityGuards;

    public LogHttpAspectFactory(List<PrivateHeaderSecurityGuard> privateHeaderSecurityGuards) {
        this.privateHeaderSecurityGuards = privateHeaderSecurityGuards;
    }

    @Override
    public HttpAspect getAspect() {
        return new LogHttpAspect(LogHttpUtils.requestUrlHeadersEntityLogFunction(privateHeaderSecurityGuards));
    }
}
