package ru.yandex.qe.http.aspects.log;

import java.io.IOException;
import java.util.List;

import com.google.common.base.Function;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.qe.logging.security.PrivateHeaderSecurityGuard;

/**
 * Established by terry
 * on 16.03.14.
 */
public class LogHttpRequestInterceptor implements HttpRequestInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(LogHttpRequestInterceptor.class);

    private final Function<HttpRequest, String> toStringFormatter;

    public LogHttpRequestInterceptor(List<PrivateHeaderSecurityGuard> privateHeaderSecurityGuards) {
        this(LogHttpUtils.requestUrlHeadersEntityLogFunction(privateHeaderSecurityGuards));
    }

    public LogHttpRequestInterceptor(Function<HttpRequest, String> toStringFormatter) {
        this.toStringFormatter = toStringFormatter;
    }

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        LOG.debug("http request interceptor phase: {}", toStringFormatter.apply(request));
    }
}
