package ru.yandex.qe.http.aspects.log;

import java.io.IOException;
import java.util.List;

import com.google.common.base.Function;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.qe.logging.security.PrivateHeaderSecurityGuard;

/**
 * Established by terry
 * on 07.02.16.
 */
public class LogHttpResponseInterceptor implements HttpResponseInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(LogHttpResponseInterceptor.class);

    private final Function<HttpResponse, String> toStringFormatter;

    public LogHttpResponseInterceptor(List<PrivateHeaderSecurityGuard> privateHeaderSecurityGuards) {
        this(LogHttpUtils.responseUrlHeadersEntityLogFunction(privateHeaderSecurityGuards));
    }

    public LogHttpResponseInterceptor(Function<HttpResponse, String> toStringFormatter) {
        this.toStringFormatter = toStringFormatter;
    }

    @Override
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        LOG.debug("http response interceptor phase: {}", toStringFormatter.apply(response));
    }
}
