package ru.yandex.qe.http.handler;

import java.util.function.Function;

import javax.annotation.concurrent.Immutable;

/**
 * @author rurikk
 */
@Immutable
class ChainingResponseHandler<T> extends FluentResponseHandler<T> {
    private FluentResponseHandler parent;
    private Function<HttpResponseReader, T> recover;

    public ChainingResponseHandler(FluentResponseHandler parent, Function<HttpResponseReader, T> recover) {
        this.parent = parent;
        this.recover = recover;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected T handleImpl(HttpResponseReader response) {
        Object result = parent.handleImpl(response);
        if (result != null) {
            return (T) result;
        }
        return recover.apply(response);
    }
}
