package ru.yandex.qe.http.redirect;

import java.util.Arrays;
import java.util.List;

import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.impl.client.DefaultRedirectStrategy;

/**
 * Established by terry
 * on 30.09.15.
 */
public class AllowMethodsRedirectStrategy extends DefaultRedirectStrategy {
    private final List<String> redirectMethods;

    public static AllowMethodsRedirectStrategy allowFor(String... methods) {
        return new AllowMethodsRedirectStrategy(Arrays.asList(methods));
    }

    public static AllowMethodsRedirectStrategy allowAll() {
        return allowFor(HttpGet.METHOD_NAME, HttpHead.METHOD_NAME,
                HttpPost.METHOD_NAME, HttpPut.METHOD_NAME, HttpDelete.METHOD_NAME,
                HttpOptions.METHOD_NAME, HttpPatch.METHOD_NAME);
    }

    public AllowMethodsRedirectStrategy(List<String> redirectMethods) {
        this.redirectMethods = redirectMethods;
    }

    @Override
    protected boolean isRedirectable(final String method) {
        for (final String m : redirectMethods) {
            if (m.equalsIgnoreCase(method)) {
                return true;
            }
        }
        return false;
    }
}
