package ru.yandex.qe.http.retries;

import java.io.IOException;

import com.google.common.base.Preconditions;
import org.apache.http.HttpResponse;
import org.apache.http.impl.client.DefaultServiceUnavailableRetryStrategy;
import org.apache.http.protocol.HttpContext;

/**
 * User: terry
 * Date: 11.09.13
 * Time: 20:30
 */
public class NTimesRetryStrategy implements RetryStrategy {

    protected final DefaultServiceUnavailableRetryStrategy unavailableRetryStrategy;
    protected final int attemptCount;

    public NTimesRetryStrategy(int attemptCount, long interval) {
        Preconditions.checkArgument(attemptCount > 0, "attempt must be positive: %s", attemptCount);
        Preconditions.checkArgument(interval >= 0, "interval mustn't be negative: %s", interval);
        this.attemptCount = attemptCount;
        unavailableRetryStrategy = new DefaultServiceUnavailableRetryStrategy(attemptCount, (int) interval);
    }

    @Override
    public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
        return unavailableRetryStrategy.retryRequest(response, executionCount, context);
    }

    @Override
    public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
        return executionCount < attemptCount;
    }

    @Override
    public long getRetryInterval() {
        return unavailableRetryStrategy.getRetryInterval();
    }
}