package ru.yandex.qe.http.retries;

import java.io.IOException;

import org.apache.http.HttpResponse;
import org.apache.http.protocol.HttpContext;

/**
 * Established by terry
 * on 26.01.16.
 */
public class NoRetryStrategy implements RetryStrategy {
    public static final RetryStrategy INSTANCE = new NoRetryStrategy();

    @Override
    public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
        return false;
    }

    @Override
    public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
        return false;
    }

    @Override
    public long getRetryInterval() {
        return 1000;
    }
}
