package ru.yandex.qe.http.retries;

import java.util.List;
import java.util.stream.Collectors;

import org.apache.http.HttpResponse;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.protocol.HttpContext;

import static java.util.Arrays.asList;

/**
 * Established by terry
 * on 05.02.16.
 */
public class StatusCodesRetryStrategy implements ServiceUnavailableRetryStrategy {

    private final List<Integer> retryStatusCodes;
    private final int maxRetries;
    private final int retryInterval;

    public StatusCodesRetryStrategy(List<Integer> retryStatusCodes, final int maxRetries, final int retryInterval) {
        this.retryStatusCodes = retryStatusCodes;
        this.maxRetries = maxRetries;
        this.retryInterval = retryInterval;
    }

    public StatusCodesRetryStrategy(String retryStatusCodes, final int maxRetries, final int retryInterval) {
        this(asList(retryStatusCodes.split(",")).stream().map(Integer::parseInt).collect(Collectors.toList()), maxRetries, retryInterval);
    }

    @Override
    public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
        return executionCount <= maxRetries &&
                retryStatusCodes.contains(response.getStatusLine().getStatusCode());
    }

    @Override
    public long getRetryInterval() {
        return retryInterval;
    }
}
