package ru.yandex.qe.http.wrap;

import java.io.IOException;

import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;

/**
 * Established by terry
 * on 14.03.14.
 */
public class HttpClientWrapper extends CloseableHttpClient {
    private CloseableHttpClient httpClient;

    public HttpClientWrapper(CloseableHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public HttpParams getParams() {
        return httpClient.getParams();
    }

    @Override
    public ClientConnectionManager getConnectionManager() {
        return httpClient.getConnectionManager();
    }

    @Override
    protected CloseableHttpResponse doExecute(HttpHost target, HttpRequest request, HttpContext context) throws IOException {
        return httpClient.execute(target, request, context);
    }

    @Override
    public void close() throws IOException {
        httpClient.close();
    }
}
