package ru.yandex.qe.http.wrap;

import java.io.IOException;
import java.util.function.Function;

import org.apache.http.HttpClientConnection;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestExecutor;

/**
 * Established by terry
 * on 27.01.16.
 */
public class HttpRequestExecutorWrapper extends HttpRequestExecutor {

    private final HttpRequestExecutor delegate;
    private final Function<HttpResponse, HttpResponseWrapper> wrapper;

    public HttpRequestExecutorWrapper(HttpRequestExecutor delegate, Function<HttpResponse, HttpResponseWrapper> wrapper) {
        this.delegate = delegate;
        this.wrapper = wrapper;
    }

    @Override
    public HttpResponse execute(HttpRequest request, HttpClientConnection conn, HttpContext context) throws IOException, HttpException {
        final HttpResponse httpResponse = delegate.execute(request, conn, context);
        return wrapper.apply(httpResponse);
    }
}
