package ru.yandex.qe.json;

import java.util.TimeZone;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.kotlin.KotlinModule;

public class DefaultJsonMapper extends com.fasterxml.jackson.databind.ObjectMapper {

    public DefaultJsonMapper() {
        setTimeZone(TimeZone.getDefault());
        registerModule(new JodaModule());
        registerModule(new URIModule());
        registerModule(new Jdk8Module());
        registerModule(new JavaTimeModule());
        registerModule(new KotlinModule.Builder().build());

        configure(SerializationFeature.INDENT_OUTPUT, false);
        configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        configure(SerializationFeature.WRITE_DATE_KEYS_AS_TIMESTAMPS, false);
        configure(SerializationFeature.WRITE_ENUMS_USING_TO_STRING, true);
        configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}
