package ru.yandex.qe.logging.security;

import java.util.ArrayList;
import java.util.List;

/**
 * Established by terry
 * on 05.02.14.
 */
public class AuthorizationSecurityGuard implements PrivateHeaderSecurityGuard {

    @Override
    public List<String> secure(String headerName, List<String> headerValues) {
        if (headerName.equalsIgnoreCase("Authorization")) {
            final List<String> securedValues = new ArrayList<>(headerValues.size());
            for (String headerValue : headerValues) {
                securedValues.add(secureValue(headerValue));
            }
            return securedValues;
        }
        return headerValues;
    }

    @Override
    public String secure(String headerName, String headerValue) {
        if (headerName.equalsIgnoreCase("Authorization")) {
            return secureValue(headerValue);
        }
        return headerValue;
    }

    private String secureValue(String headerValue) {
        if (headerValue.startsWith("OAuth")) {
            return "OAuth ***";
        }
        return headerValue;
    }
}