JAVA_LIBRARY(commons-logging)

OWNER(g:dispenser)

INCLUDE(${ARCADIA_ROOT}/intranet/dispenser/dispenser-service/versions.inc)

PEERDIR(
    contrib/java/org/slf4j/slf4j-api
    contrib/java/org/slf4j/jcl-over-slf4j
    contrib/java/org/slf4j/log4j-over-slf4j

    contrib/java/ch/qos/logback/logback-core
    contrib/java/ch/qos/logback/logback-classic

    contrib/java/org/codehaus/janino/janino

    contrib/java/com/fasterxml/jackson/core/jackson-databind

    contrib/java/javax/mail/mail
    contrib/java/com/sun/activation/jakarta.activation

    contrib/java/org/hamcrest/hamcrest-all
    contrib/java/org/mockito/mockito-core
    contrib/java/org/objenesis/objenesis
)

EXCLUDE(
    contrib/java/org/slf4j/slf4j-api
    contrib/java/ch/qos/logback/logback-core
    contrib/java/ch/qos/logback/logback-classic
    contrib/java/ch/qos/logback/logback-access
    contrib/java/com/fasterxml/jackson/core/jackson-databind
    contrib/java/com/fasterxml/jackson/core/jackson-annotations
    contrib/java/org/objenesis/objenesis
    contrib/java/org/hamcrest/hamcrest-core
    contrib/java/javax/activation/activation
)

JDK_VERSION(17)

JAVAC_FLAGS(
    -parameters
)

KOTLINC_FLAGS(
    -java-parameters
)

WITH_KOTLIN()

JAVA_SRCS(SRCDIR src/main/java **/*.java)
JAVA_SRCS(SRCDIR src/main/java **/*.kt)
JAVA_SRCS(SRCDIR src/main/resources **/*)

NO_LINT()
CHECK_JAVA_DEPS(yes)
JAVA_DEPENDENCIES_CONFIGURATION(REQUIRE_DM FORBID_DEFAULT_VERSIONS FORBID_CONFLICT_DM_RECENT)

END()

RECURSE_FOR_TESTS(
    src/test
)
