package ru.yandex.qe.spring;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AnnotationTypeFilter;

/**
 * @author lvovich
 */
public class AnnotationScanner extends ClassPathScanningCandidateComponentProvider {

    public AnnotationScanner(final Class<? extends Annotation>... annotations) {
        super(false);
        for (final Class<? extends Annotation> annotation : annotations) {
            addIncludeFilter(new AnnotationTypeFilter(annotation));
        }
    }

    public Set<Class<?>> findAnnotatedClasses(final String basePackage) {
        final Set<BeanDefinition> candidateComponents = findCandidateComponents(basePackage);
        final Set<Class<?>> annotatedClasses = new HashSet<>(candidateComponents.size());
        for (final BeanDefinition beanDefinition : candidateComponents) {
            final String className = beanDefinition.getBeanClassName();
            try {
                final Class<?> clazz = Class.forName(className);
                annotatedClasses.add(clazz);
            } catch (ClassNotFoundException e) {
                throw new RuntimeException("Impossible happened: class not found " + className, e);
            }
        }
        return annotatedClasses;
    }
}
