package ru.yandex.qe.spring;

import org.slf4j.LoggerFactory;

/**
 * A class, which logically belongs to "application top layer", like QeWebApplication of Main,
 * is responsible for initialization of versions.
 * @author lvovich
 */
public class ApplicationVersionHolder {
    public static String groupId;
    public static String artifactId;
    public static String version;

    public static String getGroupId() {
        return groupId;
    }

    public static String getVersion() {
        return version;
    }

    public static String getArtifactId() {
        return artifactId;
    }

    public static void initialize(final Class startupClass) {
        final Package applicationPackage = startupClass.getPackage();
        artifactId = applicationPackage.getImplementationTitle();
        groupId = applicationPackage.getImplementationVendor();
        version = applicationPackage.getImplementationVersion();
        LoggerFactory.getLogger(ApplicationVersionHolder.class).info("Detected application artifact {}:{}:{}",
                groupId,
                artifactId,
                version);
    }

}
