package ru.yandex.qe.spring;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;

/**
 * User: bgleb
 */
public class ProfileActivator implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    private final static Logger LOG = LoggerFactory.getLogger(ProfileActivator.class);

    @Override
    public void initialize(ConfigurableApplicationContext configurableApplicationContext) {
        // profiles set by qloud have hother precedence
        final String profiles = System.getenv("QLOUD_PROFILES");
        if (profiles != null) {
            final String[] parts = profiles.split(",");
            // clear all profiles
            configurableApplicationContext.getEnvironment().setActiveProfiles();
            for (String part : parts) {
                String profile = part.trim();
                configurableApplicationContext.getEnvironment().addActiveProfile(profile);
                LOG.info("Profile activated: {}", profile);
            }
            return;
        }
        ConfigurableEnvironment environment = configurableApplicationContext.getEnvironment();
        final String[] activeProfiles = environment.getActiveProfiles();
        if (activeProfiles.length == 0) {
            // for backward compatibility; new applications should always set spring.active.profile explicitly
            final String profile = ServerProfileDetector.detectProfile();
            LOG.info("spring.active.profiles not set, trying to activate {} profile", profile);
            configurableApplicationContext.getEnvironment().setActiveProfiles(profile);
        }
    }

}
