package ru.yandex.qe.spring;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/**
 * @author lvovich
 */
public class Qloud {

    private final String project;
    private final String application;
    private final String environment;
    private final String component;
    private final String hostname;
    private final String instance;
    private final String installation;

    private Qloud(final String project, final String application, final String environment,
                  final String component, final String hostname, final String instance, final String installation) {
        this.project = project;
        this.application = application;
        this.environment = environment;
        this.component = component;
        this.hostname = hostname;
        this.instance = instance;
        this.installation = installation == null ? "production" : installation;
    }

    public static final String QLOUD_PROJECT = "QLOUD_PROJECT";
    public static final String QLOUD_APPLICATION ="QLOUD_APPLICATION";
    public static final String QLOUD_ENVIRONMENT ="QLOUD_ENVIRONMENT";
    public static final String QLOUD_COMPONENT ="QLOUD_COMPONENT";
    public static final String QLOUD_HOSTNAME = "QLOUD_HOSTNAME";
    public static final String QLOUD_INSTANCE = "QLOUD_INSTANCE";
    public static final String QLOUD_INSTALLATION = "QLOUD_INSTALLATION";

    private static final Set<String> QLOUD_REQUIRED_VARS = new HashSet<String>() {{
        add(QLOUD_PROJECT);
        add(QLOUD_APPLICATION);
        add(QLOUD_ENVIRONMENT);
        add(QLOUD_COMPONENT);
        add(QLOUD_HOSTNAME);
    }};

    public static Qloud get() {
        final Map<String, String> env = System.getenv();
        if (env.keySet().containsAll(QLOUD_REQUIRED_VARS)) {
            return new Qloud(
                    env.get(QLOUD_PROJECT),
                    env.get(QLOUD_APPLICATION),
                    env.get(QLOUD_ENVIRONMENT),
                    env.get(QLOUD_COMPONENT),
                    env.get(QLOUD_HOSTNAME),
                    env.get(QLOUD_INSTANCE),
                    env.get(QLOUD_INSTALLATION)
            );
        } else {
            return null;
        }
    }

    public String getProject() {
        return project;
    }

    public String getApplication() {
        return application;
    }

    public String getEnvironment() {
        return environment;
    }

    public String getComponent() {
        return component;
    }

    public String getHostname() {
        return hostname;
    }

    public String getInstance() {
        return instance;
    }

    public String getInstallation() {
        return installation;
    }
}
