package ru.yandex.qe.spring;

import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.annotation.Required;

import javax.inject.Provider;
import java.util.Map;

public class SelectorFactoryBean<TYPE> implements FactoryBean<TYPE> {

    private Class<TYPE> typeClass;

    private String propertyValue;

    private Map<String, TYPE> valueToBeanMap;

    public SelectorFactoryBean(Class<TYPE> typeClass) {
        this.typeClass = typeClass;
    }

    @Required
    public void setProperty(String propertyValue) {
        this.propertyValue = propertyValue;
    }

    @Required
    public void setValueToBeanMap(Map<String, TYPE> valueToBeanMap) {
        this.valueToBeanMap = valueToBeanMap;
    }

    @Override
    public TYPE getObject() throws Exception {
        if (!valueToBeanMap.containsKey(propertyValue)) {
            throw new IllegalStateException("Property " + propertyValue + " is missing in valueToBeanMap");
        }

        Object result = valueToBeanMap.get(propertyValue);
        if (result == null) {
            //Can be used to null injected beans (e.g. in development configuration)
            //legitimate according getObject() specification
            return null;
        } else if (typeClass.isInstance(result)) {
            //noinspection unchecked
            return (TYPE) result;
        } else if ((result instanceof FactoryBean) && (typeClass.isAssignableFrom(((FactoryBean) result).getObjectType()))) {
            //noinspection unchecked
            return (TYPE) ((FactoryBean) result).getObject();
        } else if (result instanceof Provider) {
            //noinspection unchecked
            return (TYPE) ((Provider) result).get();
        } else if (result instanceof ObjectFactory) {
            //noinspection unchecked
            return (TYPE) ((ObjectFactory) result).getObject();
        }
        throw new IllegalStateException("Invalid object type! Expected " + typeClass.getName() + ", actual " + result.getClass().getName());
    }

    @Override
    public Class<?> getObjectType() {
        return typeClass;
    }

    @Override
    public boolean isSingleton() {
        return false;
    }
}
