package ru.yandex.qe.util.collect;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;

/**
 * Enumeration of collection elements.
 * @author lvovich
 */
public class CollectionEnumeration<T> implements Enumeration<T> {
    private final Iterator<T> iterator;

    public CollectionEnumeration(final Collection<T> collection) {
        this.iterator = collection.iterator();
    }

    @Override
    public boolean hasMoreElements() {
        return iterator.hasNext();
    }

    @Override
    public T nextElement() {
        return iterator.next();
    }

    public static <T> CollectionEnumeration<T> of(final Collection<T> collection) {
        return new CollectionEnumeration<>(collection);
    }
}
