package ru.yandex.qe.util;

import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

/**
 * @author rurikk
 */
public class Functions {
    public static <T, NULL> Function<T, NULL> asFunction(Consumer<T> consumer) {
        return t -> {
            consumer.accept(t);
            return null;
        };
    }

    public static <IGNORED, T> Function<IGNORED, T> asFunction(Supplier<T> supplier) {
        return ignored -> supplier.get();
    }

    public static <IGNORED> Consumer<IGNORED> asConsumer(Runnable runnable) {
        return ignored -> runnable.run();
    }

    /**
     * If you like map's forEach
     * <pre>
     * map.forEach((k, v) -> {
     *     ...
     * });
     * </pre>
     * Try the similar approach with streams:
     * <pre>
     * map.entrySet().stream()
     *     .map(kv((k, v) -> {
     *         ...
     *      }));
     * </pre>
     */
    public static <K, V, R> Function<Map.Entry<K, V>, R> kv(BiFunction<K, V, R> fn) {
        return e -> fn.apply(e.getKey(), e.getValue());
    }
}
