package ru.yandex.qe.util;

import java.util.function.Consumer;
import java.util.function.Supplier;

import javax.annotation.Nonnull;

public class Nulls {
    public static <T> T nonNull(Supplier<T> try1, Supplier<T> try2) {
        T t = try1.get();
        return t != null ? t : try2.get();
    }

    public static <T> T nonNull(Supplier<T> try1, Supplier<T> try2, Supplier<T> try3) {
        return nonNull(() -> nonNull(try1, try2), try3);
    }

    public static <T> T nonNull(Supplier<T> try1, Supplier<T> try2, Supplier<T> try3, Supplier<T> try4) {
        return nonNull(() -> nonNull(try1, try2, try3), try4);
    }

    public static <T> T nonNull(Supplier<T> try1, Supplier<T> try2, Supplier<T> try3, Supplier<T> try4, Supplier<T> try5) {
        return nonNull(() -> nonNull(try1, try2, try3, try4), try5);
    }

    /**
     * Handy method for resolving POJO path like
     * <pre>
     *  Nulls.safe(()->obj.getA().getB().getC())
     * </pre>
     * If any of intermediate object is null then result is also null.
     * <p>
     * Warning: use with caution, it hides internal NPEs
     */
    public static <T> T safe(Supplier<T> try1) {
        try {
            return try1.get();
        } catch (NullPointerException e) {
            return null;
        }
    }

    /**
     * Version of {@link Nulls#safe(Supplier)} with fallback
     */
    public static <T> T safe(Supplier<T> try1, Supplier<T> try2) {
        return nonNull(() -> safe(try1), () -> safe(try2));
    }

    /**
     * Version of {@link Nulls#safe(Supplier)} with fallbacks
     */
    public static <T> T safe(Supplier<T> try1, Supplier<T> try2, Supplier<T> try3) {
        return nonNull(() -> safe(try1), () -> safe(try2), () -> safe(try3));
    }

    /**
     * Version of {@link Nulls#safe(Supplier)} with fallback
     */
    public static <T> T safeOrDefault(Supplier<T> try1, T defaultValue) {
        return safe(try1, () -> defaultValue);
    }

    /**
     * Consumes the {@code supplier}'s result if it is not {@code null}; otherwise, does nothing.
     *
     * @param supplier result supplier
     * @param consumer result consumer
     *
     * @param <T> result type
     */
    public static <T> void whenNonNull(@Nonnull Supplier<? extends T> supplier,
                                       @Nonnull Consumer<? super T> consumer) {
        final T result = supplier.get();
        if (result != null) {
            consumer.accept(result);
        }
    }
}
