package ru.yandex.qe.util;

/**
 * @author rurikk
 */
public interface Throwing {
    @FunctionalInterface
    interface Runnable {
        void run() throws Throwable;
    }

    @FunctionalInterface
    interface Supplier<T> {
        T get() throws Throwable;
    }

    @FunctionalInterface
    interface Consumer<T> {
        void accept(T t) throws Throwable;
    }

    @FunctionalInterface
    interface Function<T, R> {
        R apply(T t) throws Throwable;
    }

    @FunctionalInterface
    interface Predicate<T> {
        boolean test(T t) throws Throwable;
    }

    @FunctionalInterface
    interface BiConsumer<T, U> {
        void accept(T t, U u) throws Throwable;
    }

    @FunctionalInterface
    interface BiFunction<T, U, R> {
        R apply(T t, U u) throws Throwable;
    }

    @FunctionalInterface
    interface BiPredicate<T, U> {
        boolean accept(T t, U u) throws Throwable;
    }
}
