package ru.yandex.inside.goals;

import java.util.Optional;

import org.apache.http.client.ClientProtocolException;

import ru.yandex.inside.goals.model.Department;
import ru.yandex.inside.goals.model.ListResponse;

/**
 * Interface to departments.
 */
public interface DepartmentsService {

    /**
     * Get departments list.
     *
     * @param pageNum  Page number starting with 1.
     * @param pageSize Departments per page. If not set and {@code pageNum} is set then 20 is used as default.
     * @return Result object with total record count and links to next/previous pages.
     * @throws ClientProtocolException If anything goes wrong. Including network problems and incorrect response from
     *                                 Goals service. Exception cause will contain original problem.
     */
    ListResponse<Department> getDepartments(Optional<Integer> pageNum, Optional<Integer> pageSize)
            throws ClientProtocolException;

    /**
     * The same as {@link #getDepartments(Optional, Optional)} but with mandatory page parameters.
     *
     * @param pageNum  Page number starting with 1.
     * @param pageSize Departments per page.
     * @return Result object with total record count and links to next/previous pages.
     * @throws ClientProtocolException If anything goes wrong. Including network problems and incorrect response from
     *                                 Goals service. Exception cause will contain original problem.
     */
    ListResponse<Department> getDepartments(int pageNum, int pageSize) throws ClientProtocolException;
}
