package ru.yandex.inside.goals;

import java.util.Optional;

import com.fasterxml.jackson.databind.JavaType;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.utils.URIBuilder;

import ru.yandex.inside.goals.model.Department;
import ru.yandex.inside.goals.model.ListResponse;

class DepartmentsServiceImpl implements DepartmentsService {

    public static final int PAGE_SIZE = 20;
    private final GoalsClient client;
    private final JavaType depResultType;

    public DepartmentsServiceImpl(GoalsClient client) {

        this.client = client;
        depResultType = client.getObjectMapper().getTypeFactory()
                .constructParametricType(ListResponse.class, Department.class);
    }

    @Override
    public ListResponse<Department> getDepartments(Optional<Integer> pageNum, Optional<Integer> pageSize)
            throws ClientProtocolException {
        URIBuilder uriBuilder = new URIBuilder(client.getUri())
                .setPath("/api/staff/groups");

        if (pageNum.isPresent()) {
            uriBuilder.addParameter("page", pageNum.get().toString())
                    .addParameter("page_size", pageSize.orElse(PAGE_SIZE).toString());
        }

        return client.getHttpUtil().doGetRequest(uriBuilder, client.getObjectMapper().reader(depResultType));
    }

    @Override
    public ListResponse<Department> getDepartments(int pageNum, int pageSize) throws ClientProtocolException {
        return getDepartments(Optional.of(pageNum), Optional.of(pageSize));
    }
}
