package ru.yandex.inside.goals;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.SimpleType;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.utils.URIBuilder;

import ru.yandex.inside.goals.model.Goal;
import ru.yandex.inside.goals.model.GoalLog;
import ru.yandex.inside.goals.model.ListResponse;

/**
 * Goals service implementation.
 */
class GoalsServiceImpl implements GoalsService {

    private final GoalsClient client;

    private final JavaType goalLogType;

    public GoalsServiceImpl(GoalsClient client) {
        this.client = client;
        goalLogType = CollectionType.construct(ArrayList.class, SimpleType.construct(GoalLog.class));
    }

    @Override
    public GoalsRequestBuilder getGoalsBuilder() {
        return new GoalsRequestBuilderImpl(client);
    }

    @Override
    public ListResponse<Goal> getGoals(int pageNum, int perPage) throws ClientProtocolException {
        return getGoalsBuilder().pageNum(pageNum).perPage(perPage).getGoals();
    }

    @Override
    public List<GoalLog> getGoalLog(int id) throws ClientProtocolException {
        URIBuilder uriBuilder = new URIBuilder(client.getUri())
                .setPath("/api/v1/log")
                .addParameter("goal", Integer.toString(id));

        return client.getHttpUtil().doGetRequest(uriBuilder, client.getObjectMapper().reader(goalLogType));
    }

    @Override
    public Goal parseGoal(String json) throws IOException {
        return client.getObjectMapper().readValue(json, Goal.class);
    }

}
