package ru.yandex.inside.goals.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class Department {

    private final int staffId;
    private final String name;
    private final List<UserRef> heads;

    @JsonCreator
    public Department(@JsonProperty("staff_id") int staffId,
                      @JsonProperty("name") String name,
                      @JsonProperty("heads") List<UserRef> heads) {
        this.staffId = staffId;
        this.name = name;
        this.heads = heads;
    }

    public int getStaffId() {
        return staffId;
    }

    public String getName() {
        return name;
    }

    public List<UserRef> getHeads() {
        return heads;
    }
}
